<?php
namespace AmazonAssociatesLinkBuilder\helper;

use SimpleXMLElement;

class Xml_Bridge
{
    /**
     * @param mixed $response
     * @param string $type
     * @return SimpleXMLElement
     */
    public function get_xml_from_api_response($response, $type = 'GetItem')
    {

        $xml = new SimpleXMLElement('<Items></Items>');
        if ((!isset($response->ItemsResult) && !isset($response->SearchResult)) || isset($response->Errors[0]->Code)) {
            $error = $xml->addChild('Request')->addChild('Errors')->addChild('Error');
            $error->addChild('Code', $response->Errors[0]->Code);
            $error->addChild('Message', $response->Errors[0]->Message);
            //$xml->Items->Request->Errors->Error->Code;
            //return $xml;
        }

        if ($type === 'SearchItems') {
            $xml->addChild('TotalResults', $response->SearchResult->TotalResultCount);
            $xml->addChild('TotalPages', ceil($response->SearchResult->TotalResultCount / 10));
            $xml->addChild('MoreSearchResultsUrl', htmlspecialchars($response->SearchResult->SearchURL));
            if (isset($response->SearchResult)){
                $items = $response->SearchResult->Items;
            }
        } else {
            if (isset($response->ItemsResult)){
                $items = $response->ItemsResult->Items;
            }
        }
        if (isset($items) && is_array($items)) {
            foreach ($items as $responseItem) {
                $item = $xml->addChild('Item');
                $item->addChild('ASIN', $responseItem->ASIN);
                $item->addChild('DetailPageURL', htmlspecialchars($responseItem->DetailPageURL));
                $this->set_images($item, $responseItem);
                $this->set_image_sets($item, $responseItem);
                $this->set_item_attributes($item, $responseItem);
                $this->set_offer_summary($item, $responseItem);
                if (isset($responseItem->Offers)) {
                    $this->set_offers($item, $responseItem);
                } else {
                    $this->set_offers_empty($item, $responseItem);
                }
            }
        }
        //var_dump($xml->asXML());
        return $xml;
    }

    /**
     * @param SimpleXMLElement $item
     * @param mixed $responseItem
     */
    private function set_offer_summary($item, $responseItem)
    {
        $offer_summary = $item->addChild('OfferSummary');
        $summaries = isset($responseItem->Offers->Summaries) ? $responseItem->Offers->Summaries[0] : null;
        $lowest_new_price = $offer_summary->addChild('LowestNewPrice');
        $lowest_new_price->addChild('Amount', isset($summaries->LowestPrice->Amount) ? $summaries->LowestPrice->Amount : 0);
        $lowest_new_price->addChild('CurrencyCode', isset($summaries->LowestPrice->Currency) ? $summaries->LowestPrice->Currency : 0);
        $lowest_new_price->addChild('FormattedPrice', isset($summaries->LowestPrice->DisplayAmount) ? $summaries->LowestPrice->DisplayAmount : 0);
        $offer_summary->addChild('TotalNew', isset($summaries->OfferCount) ? $summaries->OfferCount : 0);
    }

    /**
     * @param SimpleXMLElement $item
     * @param mixed $responseItem
     */
    private function set_offers_empty($item, $responseItem)
    {
        $offers = $item->addChild('Offers');
        $offers->addChild('TotalOffers', 0);
        $offers->addChild('TotalOfferPages', 0);
        $offers->addChild('MoreOffersUrl', 0);
    }

    /**
     * @param SimpleXMLElement $item
     * @param mixed $responseItem
     */
    private function set_offers($item, $responseItem)
    {
        $offers = $item->addChild('Offers');
        $listing = $responseItem->Offers->Listings[0];
        $offers->addChild('TotalOffers', $responseItem->Offers->Summaries[0]->OfferCount);
        $offer = $offers->addChild('Offer');
        $offer->addChild('Merchant', htmlspecialchars($listing->MerchantInfo->Name));
        $offer->addChild('OfferAttributes')->addChild('Condition', $listing->Condition->Value);
        $offer_listing = $offer->addChild('OfferListing');
        $offer_listing->addChild('OfferListingId', $listing->Id);
        $price = $offer_listing->addChild('Price');

        if (isset($listing->Price->Savings)) {
            $price->addChild('Amount', $listing->SavingBasis->Amount);
            $price->addChild('CurrencyCode', $listing->SavingBasis->Currency);
            $price->addChild('FormattedPrice', $listing->SavingBasis->DisplayAmount);
            $sale_price = $offer_listing->addChild('SalePrice');
            $sale_price->addChild('Amount', $listing->Price->Amount);
            $sale_price->addChild('CurrencyCode', $listing->Price->Currency);
            $sale_price->addChild('FormattedPrice', $listing->Price->DisplayAmount);
            $amount_saved = $offer_listing->addChild('AmountSaved');
            $amount_saved->addChild('Amount', $listing->Price->Savings->Amount);
            $amount_saved->addChild('CurrencyCode', $listing->Price->Savings->Currency);
            $amount_saved->addChild('FormattedPrice', $listing->Price->Savings->DisplayAmount);
            $offer_listing->addChild('PercentageSaved', $listing->Price->Savings->Percentage);
        } else {
            $price->addChild('Amount', $listing->Price->Amount);
            $price->addChild('CurrencyCode', $listing->Price->Currency);
            $price->addChild('FormattedPrice', $listing->Price->DisplayAmount);
        }
        $offer_listing->addChild('Availability', $listing->Availability->Message);
        $offer_listing->addChild('AvailabilityAttributes')->addChild('AvailabilityType', $listing->Availability->Type);
        $offer_listing->addChild('IsEligibleForSuperSaverShipping', $listing->DeliveryInfo->IsFreeShippingEligible);
        $offer_listing->addChild('IsEligibleForPrime', $listing->DeliveryInfo->IsPrimeEligible);
    }

    /**
     * @param SimpleXMLElement $item
     * @param mixed $responseItem
     */
    private function set_item_attributes($item, $responseItem)
    {
        /** @var SimpleXMLElement $item */
        $item_attributes = $item->addChild('ItemAttributes');
        $item_attributes->addChild('Title', htmlspecialchars($responseItem->ItemInfo->Title->DisplayValue));
        $item_attributes->addChild('Brand', htmlspecialchars($responseItem->ItemInfo->ByLineInfo->Brand->DisplayValue));
        $item_attributes->addChild('Manufacturer', htmlspecialchars($responseItem->ItemInfo->ByLineInfo->Brand->DisplayValue));
        if (isset($responseItem->ItemInfo->ByLineInfo->Manufacturer->DisplayValue)){
            $item_attributes->addChild('Manufacturer', htmlspecialchars($responseItem->ItemInfo->ByLineInfo->Manufacturer->DisplayValue));
        }
        if (isset($responseItem->ItemInfo->ProductInfo->Color)) {
            $item_attributes->addChild('Color', htmlspecialchars($responseItem->ItemInfo->ProductInfo->Color->DisplayValue)); // ?
        }
        //$item_attributes->addChild('Color', $responseItem->ItemInfo->ByLineInfo->Brand->DisplayValue);
        if (isset($responseItem->ItemInfo->ExternalIds)) {
            $item_attributes->addChild('EAN', $responseItem->ItemInfo->ExternalIds->EANs->DisplayValues[0]);
            $item_attributes->addChild('EANList')->addChild('EANListElement', $responseItem->ItemInfo->ExternalIds->EANs->DisplayValues[0]);
        }
        if (isset($responseItem->ItemInfo->Feature) && is_array($responseItem->ItemInfo->Features->DisplayValues)) {
            foreach ($responseItem->ItemInfo->Features->DisplayValues as $feature) {
                $item_attributes->addChild('Feature', htmlspecialchars($feature));
            }
        }
        if (isset($responseItem->ItemInfo->ProductInfo->IsAdultProduct->DisplayValue)){
            $item_attributes->addChild('IsAdultProduct', (int) $responseItem->ItemInfo->ProductInfo->IsAdultProduct->DisplayValue);
        }

        $item_dimensions = $item_attributes->addChild('ItemDimensions');
        if (isset($responseItem->ItemInfo->ProductInfo->ItemDimensions)){
            if (isset($responseItem->ItemInfo->ProductInfo->ItemDimensions->Height)) {
                $height = $responseItem->ItemInfo->ProductInfo->ItemDimensions->Height;
                $item_dimensions->addChild('Height', $height->DisplayValue)->addAttribute('Unit', $height->Unit);
            }
            if (isset($responseItem->ItemInfo->ProductInfo->ItemDimensions->Length)) {
                $length = $responseItem->ItemInfo->ProductInfo->ItemDimensions->Length;
                $item_dimensions->addChild('length', $length->DisplayValue)->addAttribute('Unit', $length->Unit);
            }
            if (isset($responseItem->ItemInfo->ProductInfo->ItemDimensions->Weight)) {
                $weight = $responseItem->ItemInfo->ProductInfo->ItemDimensions->Weight;
                $item_dimensions->addChild('weight', $weight->DisplayValue)->addAttribute('Unit', $weight->Unit);
            }
            if (isset($responseItem->ItemInfo->ProductInfo->ItemDimensions->Width)) {
                $width = $responseItem->ItemInfo->ProductInfo->ItemDimensions->Width;
                $item_dimensions->addChild('width', $width->DisplayValue)->addAttribute('Unit', $width->Unit);
            }
        }

        if (isset($responseItem->ItemInfo->ManufactureInfo->ItemPartNumber)){
            $item_attributes->addChild('MPN', htmlspecialchars($responseItem->ItemInfo->ManufactureInfo->ItemPartNumber->DisplayValue)); //?
            $item_attributes->addChild('PartNumber', htmlspecialchars($responseItem->ItemInfo->ManufactureInfo->ItemPartNumber->DisplayValue)); //?
        }
        if (isset($responseItem->ItemInfo->Classifications->ProductGroup)) {
            $item_attributes->addChild('ProductGroup', htmlspecialchars($responseItem->ItemInfo->Classifications->ProductGroup->DisplayValue));
        }
        if (isset($responseItem->ItemInfo->Classifications->Binding)){
            $item_attributes->addChild('Binding', htmlspecialchars($responseItem->ItemInfo->Classifications->Binding->DisplayValue));
        }
        if (isset($responseItem->ItemInfo->ProductInfo->Size)) {
            $item_attributes->addChild('Size', htmlspecialchars($responseItem->ItemInfo->ProductInfo->Size->DisplayValue));
        }
    }

    /**
     * @param SimpleXMLElement$item
     * @param mixed $responseItem
     */
    private function set_image_sets($item, $responseItem)
    {
        $image_sets = $item->addChild('ImageSets');
        $variants = isset($responseItem->Images->Variants) ? $responseItem->Images->Variants : null;
        if (is_array($variants)) {
            foreach ($variants as $variant) {
                $image_set = $image_sets->addChild('ImageSet');
                $image_set->addAttribute('Category', 'variant');

                $swatch = $image_set->addChild('SwatchImage');
                $swatch->addChild('URL', $variant->Small->URL);
                $swatch->addChild('Height', $variant->Small->Height)->addAttribute('Units', 'pixels');
                $swatch->addChild('Width', $variant->Small->Width)->addAttribute('Units', 'pixels');

                $small = $image_set->addChild('SmallImage');
                $small->addChild('URL', $variant->Small->URL);
                $small->addChild('Height', $variant->Small->Height)->addAttribute('Units', 'pixels');
                $small->addChild('Width', $variant->Small->Width)->addAttribute('Units', 'pixels');

                $thumbnail = $image_set->addChild('ThumbnailImage');
                $thumbnail->addChild('URL', $variant->Small->URL);
                $thumbnail->addChild('Height', $variant->Small->Height)->addAttribute('Units', 'pixels');
                $thumbnail->addChild('Width', $variant->Small->Width)->addAttribute('Units', 'pixels');

                $tiny = $image_set->addChild('TinyImage');
                $tiny->addChild('URL', $variant->Medium->URL);
                $tiny->addChild('Height', $variant->Medium->Height)->addAttribute('Units', 'pixels');
                $tiny->addChild('Width', $variant->Medium->Width)->addAttribute('Units', 'pixels');

                $medium = $image_set->addChild('MediumImage');
                $medium->addChild('URL', $variant->Medium->URL);
                $medium->addChild('Height', $variant->Medium->Height)->addAttribute('Units', 'pixels');
                $medium->addChild('Width', $variant->Medium->Width)->addAttribute('Units', 'pixels');

                $large = $image_set->addChild('LargeImage');
                $large->addChild('URL', $variant->Large->URL);
                $large->addChild('Height', $variant->Large->Height)->addAttribute('Units', 'pixels');
                $large->addChild('Width', $variant->Large->Width)->addAttribute('Units', 'pixels');
            }
        }
    }

    /**
     * @param SimpleXMLElement$item
     * @param mixed $responseItem
     */
    private function set_images($item, $responseItem)
    {
        $small_image = $item->addChild('SmallImage');
        $small_image->addChild('URL', $responseItem->Images->Primary->Small->URL);
        $small_image->addChild('Height', $responseItem->Images->Primary->Small->Height);
        $small_image->addChild('Width', $responseItem->Images->Primary->Small->Width);
        $medium_image = $item->addChild('MediumImage');
        $medium_image->addChild('URL', $responseItem->Images->Primary->Medium->URL);
        $medium_image->addChild('Height', $responseItem->Images->Primary->Medium->Height);
        $medium_image->addChild('Width', $responseItem->Images->Primary->Medium->Width);
        $large_image = $item->addChild('LargeImage');
        $large_image->addChild('URL', $responseItem->Images->Primary->Large->URL);
        $large_image->addChild('Height', $responseItem->Images->Primary->Large->Height);
        $large_image->addChild('Width', $responseItem->Images->Primary->Large->Width);
    }


}
