<?php


namespace AmazonAssociatesLinkBuilder\helper;

/*use Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\GetItemsRequest;
use Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\GetItemsResource;
use Amazon\ProductAdvertisingAPI\v1\com\amazon\paapi5\v1\PartnerType;
use Amazon\ProductAdvertisingAPI\v1\Configuration;*/
use AmazonAssociatesLinkBuilder\configuration\Config_Loader;
use AmazonAssociatesLinkBuilder\constants\Db_Constants;
use AmazonAssociatesLinkBuilder\constants\Paapi5_Constants;
use AmazonAssociatesLinkBuilder\constants\Plugin_Constants;
use Exception;

class Paapi5_Helper
{
    /** @var Config_Loader  */
    private $config_loader;

    public function __construct()
    {
        $this->config_loader = new Config_Loader();
    }

    private function get_access_key_id()
    {
        return openssl_decrypt( base64_decode( get_option( Db_Constants::AWS_ACCESS_KEY ) ), Plugin_Constants::ENCRYPTION_ALGORITHM, Plugin_Constants::ENCRYPTION_KEY, 0, Plugin_Constants::ENCRYPTION_IV );
    }

    private function get_secret_key()
    {
        return openssl_decrypt( base64_decode( get_option( Db_Constants::AWS_SECRET_KEY ) ), Plugin_Constants::ENCRYPTION_ALGORITHM, Plugin_Constants::ENCRYPTION_KEY, 0, Plugin_Constants::ENCRYPTION_IV );
    }

    /**
     * @param string $marketplace
     * @return //Configuration
     */
/*    private function get_configuration($marketplace)
    {
        $access_key_id = openssl_decrypt( base64_decode( get_option( Db_Constants::AWS_ACCESS_KEY ) ), Plugin_Constants::ENCRYPTION_ALGORITHM, Plugin_Constants::ENCRYPTION_KEY, 0, Plugin_Constants::ENCRYPTION_IV );
        $secret_key = openssl_decrypt( base64_decode( get_option( Db_Constants::AWS_SECRET_KEY ) ), Plugin_Constants::ENCRYPTION_ALGORITHM, Plugin_Constants::ENCRYPTION_KEY, 0, Plugin_Constants::ENCRYPTION_IV );

        $host = $this->get_marketplace_endpoint($marketplace);
        $config = new Configuration();
        $config->setAccessKey($access_key_id);
        $config->setSecretKey($secret_key);
        $config->setHost($host);
        $config->setRegion(Paapi5_Constants::REGIONS_FOR_HOSTS[$host]);
        $config->setDebug(true);

        return $config;
    }*/

    /**
     * Get marketplace endpoint for marketplace abbreviation
     *
     * @since 1.8.0
     *
     * @param string $marketplace_abbr Marketplace Abbreviation from shortcode
     *
     * @return string $marketplace_endpoint Marketplace endpoint
     */
    private function get_marketplace_endpoint( $marketplace_abbr )
    {
        $aalb_marketplace_names = $this->config_loader->fetch_marketplaces();
        $marketplace_endpoint = array_search( $marketplace_abbr, $aalb_marketplace_names );

        return $marketplace_endpoint;
    }

    /**
     * @param string $marketplace
     * @return AwsV4
     */
    public function get_api_instance($marketplace)
    {
        $host = $this->get_marketplace_endpoint($marketplace);

        $awsv4 = new awsv4 ($this->get_access_key_id(), $this->get_secret_key());
        $awsv4->setRegionName(Paapi5_Constants::REGIONS_FOR_HOSTS[$host]);
        $awsv4->setServiceName(Paapi5_Constants::SERVICE_NAME);
        $awsv4->setRequestMethod ("POST");
        $awsv4->addHeader('content-encoding', 'amz-1.0');
        $awsv4->addHeader('content-type', 'application/json; charset=utf-8');
        $awsv4->addHeader('host', $host);

        return $awsv4;
    }

    /**
     * Gets payload for new GetItems request
     *
     * @param string $marketplace
     * @param array $asins_array
     * @param string $store_id
     * @return array|false|mixed|string|void
     */
    public function get_payload_get_items($marketplace, $asins_array, $store_id )
    {
        $payload = [
            'ItemIds'   => $asins_array,
            'Resources' => Paapi5_Constants::DEFAULT_RESOURCES,
            'PartnerTag' => $store_id,
            'PartnerType' => Paapi5_Constants::PARTNER_TYPE,
            'Marketplace' => Paapi5_Constants::MARKETPLACE_NAMES[$marketplace],
        ];
        $payload = json_encode($payload);
        return $payload;
    }

    /**
     * Gets payload for new SearchItems request
     *
     * @param string $marketplace
     * @param array $keywords
     * @param string $store_id
     * @return array|false|mixed|string|void
     */
    public function get_payload_search_items($marketplace, $keywords, $store_id )
    {
        $payload = [
            'Keywords'   => $keywords,
            'Resources' => Paapi5_Constants::DEFAULT_RESOURCES,
            'PartnerTag' => $store_id,
            'PartnerType' => Paapi5_Constants::PARTNER_TYPE,
            'Marketplace' => Paapi5_Constants::MARKETPLACE_NAMES[$marketplace],
        ];
        $payload = json_encode($payload);
        return $payload;
    }

    /**
     * @param AwsV4 $api_instance
     * @param $operation
     * @return array|mixed|object
     * @throws Exception
     */
    public function send_request($api_instance, $operation)
    {
        $api_instance->addHeader('x-amz-target', Paapi5_Constants::API_OPERATION_HEADERS[$operation]);
        $api_instance->setPath(Paapi5_Constants::API_OPERATION_ENDPOINTS[$operation]);
        $headers = $api_instance->getHeaders();
        $host = $headers['host'];
        $header_string = $this->get_header_string($headers);

        $params = array (
            'http' => array (
                'header' => $header_string,
                'method' => 'POST',
                'content' => $api_instance->getPayload()
            )
        );
        $stream = stream_context_create ( $params );

        $fp = @fopen ( 'https://'.$host.$api_instance->getPath(), 'rb', false, $stream );
        if (!$fp) {
            file_put_contents('aalbpl.log', 'FP!: '.$api_instance->getPayload(), FILE_APPEND);
            throw new Exception ( "Exception Occured" );
        }
        $response = json_decode(@stream_get_contents ( $fp ));

        /*if (strpos($api_instance->getPayload(), 'B002HORIN4') || strpos($api_instance->getPayload(), 'B07PZ6DWCX')) {
            echo "<pre>";
            echo "response:";
            var_dump($response);
            echo "</pre>";
        }*/

        if ($response === false) {
            file_put_contents('aalbpl.log', 'Response!: '.$api_instance->getPayload(), FILE_APPEND);
            throw new Exception ( "Exception Occured" );
        }

        return $response;
    }

    private function get_header_string($headers)
    {
        $headerString = '';
        foreach ($headers as $key => $value) {
            if ($key === 'host') {
                $host = $value;
            }
            $headerString .= $key . ': ' . $value . "\r\n";
        }
        return $headerString;
    }
}