<?php
/*
Copyright 2016-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.

Licensed under the GNU General Public License as published by the Free Software Foundation,
Version 2.0 (the "License"). You may not use this file except in compliance with the License.
A copy of the License is located in the "license" file accompanying this file.

This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
either express or implied. See the License for the specific language governing permissions
and limitations under the License.
*/

namespace AmazonAssociatesLinkBuilder\constants;

/**
 * Class for Holding Paapi Constants
 *
 * @since      1.8.0
 * @package    AmazonAssociatesLinkBuilder
 * @subpackage AmazonAssociatesLinkBuilder/constants
 */

class Paapi5_Constants {

    const PARTNER_TYPE = 'Associates';
    const INVALID_PARAMETER_VALUE_ERROR = 'InvalidParameterValue';

    const REGIONS_FOR_HOSTS = [
        'webservices.amazon.com.au' => 'us-west-2',
        'webservices.amazon.com.br' => 'us-east-1',
        'webservices.amazon.ca'     => 'us-east-1',
        'webservices.amazon.fr'     => 'eu-west-1',
        'webservices.amazon.de'     => 'eu-west-1',
        'webservices.amazon.in'     => 'eu-west-1',
        'webservices.amazon.it'     => 'eu-west-1',
        'webservices.amazon.co.jp'  => 'us-west-2',
        'webservices.amazon.com.mx' => 'us-east-1',
        'webservices.amazon.sg'     => 'us-west-2',
        'webservices.amazon.es'     => 'eu-west-1',
        'webservices.amazon.com.tr' => 'eu-west-1',
        'webservices.amazon.ae'     => 'eu-west-1',
        'webservices.amazon.co.uk'  => 'eu-west-1',
        'webservices.amazon.com'    => 'us-east-1',
    ];

    const MARKETPLACE_NAMES = [
        'AU' => 'www.amazon.com.au',
        'BR' => 'www.amazon.com.br',
        'CA' => 'www.amazon.ca',
        'DE' => 'www.amazon.de',
        'ES' => 'www.amazon.es',
        'FR' => 'www.amazon.fr',
        'IN' => 'www.amazon.in',
        'IT' => 'www.amazon.it',
        'JP' => 'www.amazon.co.jp',
        'MX' => 'www.amazon.com.mx',
        'TR' => 'www.amazon.tr',
        'UK' => 'www.amazon.co.uk',
        'US' => 'www.amazon.com',
    ];

    const MARKETPLACE_HOSTS = [
        'AU' => 'webservices.amazon.com.au',
        'BR' => 'webservices.amazon.com.br',
        'CA' => 'webservices.amazon.ca',
        'DE' => 'webservices.amazon.de',
        'ES' => 'webservices.amazon.es',
        'FR' => 'webservices.amazon.fr',
        'IN' => 'webservices.amazon.in',
        'IT' => 'webservices.amazon.it',
        'JP' => 'webservices.amazon.co.jp',
        'MX' => 'webservices.amazon.com.mx',
        'TR' => 'webservices.amazon.tr',
        'UK' => 'webservices.amazon.co.uk',
        'US' => 'webservices.amazon.com',
    ];

    const DEFAULT_RESOURCES = [
        'Images.Primary.Small',
        'Images.Primary.Medium',
        'Images.Primary.Large',
        'Images.Variants.Small',
        'Images.Variants.Medium',
        'Images.Variants.Large',
        'ItemInfo.ByLineInfo',
        'ItemInfo.ContentInfo',
        'ItemInfo.ContentRating',
        'ItemInfo.Classifications',
        'ItemInfo.ExternalIds',
        'ItemInfo.Features',
        'ItemInfo.ManufactureInfo',
        'ItemInfo.ProductInfo',
        'ItemInfo.TechnicalInfo',
        'ItemInfo.Title',
        'ItemInfo.TradeInInfo',
        'Offers.Listings.Availability.MaxOrderQuantity',
        'Offers.Listings.Availability.Message',
        'Offers.Listings.Availability.MinOrderQuantity',
        'Offers.Listings.Availability.Type',
        'Offers.Listings.Condition',
        'Offers.Listings.Condition.SubCondition',
        'Offers.Listings.DeliveryInfo.IsAmazonFulfilled',
        'Offers.Listings.DeliveryInfo.IsFreeShippingEligible',
        'Offers.Listings.DeliveryInfo.IsPrimeEligible',
        'Offers.Listings.DeliveryInfo.ShippingCharges',
        'Offers.Listings.IsBuyBoxWinner',
        'Offers.Listings.LoyaltyPoints.Points',
        'Offers.Listings.MerchantInfo',
        'Offers.Listings.Price',
        'Offers.Listings.ProgramEligibility.IsPrimeExclusive',
        'Offers.Listings.ProgramEligibility.IsPrimePantry',
        'Offers.Listings.Promotions',
        'Offers.Listings.SavingBasis',
        'Offers.Summaries.HighestPrice',
        'Offers.Summaries.LowestPrice',
        'Offers.Summaries.OfferCount'
    ];

    const SERVICE_NAME = 'ProductAdvertisingAPI';

    const API_OPERATION_ENDPOINTS = [
        'GetItems'    => '/paapi5/getitems',
        'SearchItems' => '/paapi5/searchitems',
    ];
    const API_OPERATION_HEADERS = [
        'GetItems'    => 'com.amazon.paapi5.v1.ProductAdvertisingAPIv1.GetItems',
        'SearchItems' => 'com.amazon.paapi5.v1.ProductAdvertisingAPIv1.SearchItems',
    ];

    const URI = '/onca/xml';
    const VERSION = '2013-08-01';
}

?>